function [genPolyDec, numBits, iniStatesDec, numChecksums] = ...
    commblkcrcgen2(genPoly, iniStates, numChecksums)
%COMMBLKCRCGEN2 Mask function for CRC generator and CRC
% syndrome detector blocks for parameter checking.

%   Copyright 1996-2001 The MathWorks, Inc.
%   $Revision: 1.3 $  $Date: 2001/11/15 22:26:04 $

% Check the Generator Polynomial parameter
if ~(isvector(genPoly) | isscalar(genPoly))
    error('The generator polynomial parameter must be a binary vector.');
end
if any(genPoly~=1 & genPoly~=0)
    error('The generator polynomial parameter must be a binary vector.');
end
if ((genPoly(1) == 0) | (genPoly(end) == 0))
    error('Invalid generator polynomial parameter values.');
end

% Check the Degree of polynomial
numBits = length(genPoly)-1;
if numBits > 32
    error('Only generator polynomials of degree 32 or less are allowed.');
end

% Convert to decimal value
if ( isscalar(genPoly) & (genPoly == 1) )
    genPolyDec = 0;     % numBits = 0
else 
    genPolyDec = bi2de(genPoly(2:end),'left-msb'); % without the leading implicit bit
end

% Check the Initial States parameter
if ~(isvector(iniStates) | isscalar(iniStates))
    error('The initial states parameter must be a scalar or a vector of size equal to the degree of the generator polynomial.');
end
if any(iniStates~=1 & iniStates~=0)
    error('The initial states parameter values must be binary.');
end
if length(iniStates) == 1 % scalar expansion
    iniStates = iniStates*ones(1,numBits);
elseif length(iniStates) ~= numBits
    error('The initial states parameter must be a scalar or a vector of size equal to the degree of the generator polynomial.');
end

% Convert to decimal value
if isempty(iniStates)
    iniStatesDec = 0;     % numBits = 0
else 
    iniStatesDec = bi2de(iniStates, 'left-msb');
end

% Check the number of Checksums parameter
if ( isempty(numChecksums) | ~isreal(numChecksums) | isinf(numChecksums) | ...
    (numChecksums <= 0) | (floor(numChecksums) ~= numChecksums) | ...
    ~isscalar(numChecksums) )
    error('The checksums per frame parameter must be an integer scalar greater than 0.');
end

% [EOF]
